(*************************************************************************
 *  ToolCleanAllU.pas                                                    *
 *  Vladimr Slvik 2009-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Tool for removing all special colours.                               *
 *                                                                       *
 *  -additional libraries: Graphics32                                    *
 *************************************************************************)

unit ToolCleanAllU;

{$INCLUDE ..\Switches.inc}
{t default -}

//------------------------------------------------------------------------------

interface

uses ClassBaseU, GR32;

//------------------------------------------------------------------------------

type TCleanAllTool = class(TStaticToolBase)
     public
       procedure Act; override;
     end; 

//==============================================================================
implementation

uses Windows, Forms, SysUtils,
     TranslationU,
     CoreLowU, CoreEngineU, CalcUtilU, ConstStrU;
//==============================================================================

procedure TCleanAllTool.Act;
var ActionPlace: TRect;
begin
    with FEngine.ToolOptions do if RemoveGlowing or RemovePlayer then begin
      // anything to do?
      if Application.MessageBox(PChar(_('Clean all special colors?')), //t+
        PChar(Translate(sscMsgCapProceed)),
        MB_YESNO + MB_ICONQUESTION) = IDYes
      then begin // ask user
        // resize and clear with masking color -> whole picture will be cleaned
        FEngine.CopyOverlay;
        with FEngine, ToolOptions do CleanWhole(Overlay, RemoveGlowing, RemovePlayer);
        // this is sorta suboptimal but legacy, works and will be reused and rewritten anyway!
        ActionPlace:= FEngine.BoundsRect;
        FEngine.CommitOverlay(ActionPlace);
        FEngine.RedrawRect(ActionPlace);
      end;
    end else Application.MessageBox(
      PChar(_('Neither kind of special colours can be cleaned. Please switch at least one on!')), //t+
      PChar(Translate(sscMsgCapError)),
      MB_OK + MB_ICONERROR);
end;

//------------------------------------------------------------------------------

end.
