(*************************************************************************
 *  OptionU.pas + OptionU.dfm                                            *
 *  Vladimr Slvik 2005-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  option form of Shades :                                              *
 *    mainly controls and conversion between UI and internal values      *
 *                                                                       *
 *  -additional libraries: Graphics32                                    *
 *************************************************************************)

unit OptionU;

{$INCLUDE Switches.inc}
{t default -}

interface

uses
  Windows, SysUtils, Classes, StdCtrls, Buttons, Controls, ExtCtrls,
  ComCtrls, Forms,
  ConfigU;

//------------------------------------------------------------------------------

type
  TOptionFrm = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    PageControl: TPageControl;
    tsZoom: TTabSheet;
    tsHighlightColors: TTabSheet;
    Label4: TLabel;
    cbxZoomLevel: TComboBox;
    Label10: TLabel;
    edtHighlightBlendCl: TEdit;
    Label11: TLabel;
    edtHighlightPicWeight: TEdit;
    edtHighlightGlowCl: TEdit;
    Label9: TLabel;
    Label13: TLabel;
    edtHighlightPlayerPriCl: TEdit;
    tsFiles: TTabSheet;
    Label7: TLabel;
    cbxFilesPngCompLevel: TComboBox;
    tsMouse: TTabSheet;
    Label12: TLabel;
    edtMouseScrollX: TEdit;
    cbMouseHorzScroll: TCheckBox;
    edtMouseHorzPart: TEdit;
    Label17: TLabel;
    tsNightColors: TTabSheet;
    Label14: TLabel;
    edtNightBlendingCl: TEdit;
    Label15: TLabel;
    edtNightPicWeight: TEdit;
    Bevel1: TBevel;
    edtMouseScrollY: TEdit;
    Label16: TLabel;
    Label18: TLabel;
    imgMouse: TImage;
    imgZoom: TImage;
    imgHighlight: TImage;
    imgNight: TImage;
    imgFiles: TImage;
    shpHighlightBlendCl: TShape;
    shpHighlightGlowCl: TShape;
    shpHighlightPlayerPriCl: TShape;
    shpNightBlendingCl: TShape;
    tsUndo: TTabSheet;
    imgUndo: TImage;
    cbRestrictUndo: TCheckBox;
    edtUndoRestrict: TEdit;
    Label19: TLabel;
    tsInterface: TTabSheet;
    imgInterface: TImage;
    cbCloseBtn: TCheckBox;
    cbMouseCursors: TCheckBox;
    cbAddToRecent: TCheckBox;
    Label20: TLabel;
    rbtnTBAlignTop: TRadioButton;
    rbtnTBAlignBottom: TRadioButton;
    Label21: TLabel;
    btnShowDataFolder: TSpeedButton;
    edtHighlightPlayerSecCl: TEdit;
    Label23: TLabel;
    shpHighlightPlayerSecCl: TShape;
    cbTimeStamp: TCheckBox;
    cbSounds: TCheckBox;
    Label24: TLabel;
    lbTransFiles: TListBox;
    Label25: TLabel;
    btnRefreshTransList: TButton;
    cbDecimalIndicator: TCheckBox;
    btnAutoChooseTrans: TButton;
    tsTools: TTabSheet;
    imgTools: TImage;
    cbCustomRecolor: TCheckBox;
    procedure btnOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cbMouseHorzScrollClick(Sender: TObject);
    procedure ColorEditChange(Sender: TObject);
    procedure cbRestrictUndoClick(Sender: TObject);
    procedure btnShowDataFolderClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnRefreshTransListClick(Sender: TObject);
    procedure btnAutoChooseTransClick(Sender: TObject);
  private
    FOptions: TSdiEdOptions;
    procedure SetOptions(const Options: TSdiEdOptions);
  public
    property Options: TSdiEdOptions read FOptions write SetOptions;
  end;

var OptionFrm: TOptionFrm;

//==============================================================================
implementation
//==============================================================================

uses Math, StrUtils, ShellAPI, Graphics, TypInfo,
     GR32,
     ColorU, FileU, StrU, TranslationU, TransGuiU,
     MainU, SysLowU, ConstStrU,
     AboutU, BackPicU, ClChgU, NightOptU, StatU;

{$R *.dfm}

//------------------------------------------------------------------------------

procedure TOptionFrm.SetOptions(const Options: TSdiEdOptions);
begin
  FOptions:= Options;
  with FOptions do begin
    with MouseOpt do begin
      edtMouseScrollX.Text:= IntToStr(ScrollFactorX);
      edtMouseScrollY.Text:= IntToStr(ScrollFactorY);
      cbMouseHorzScroll.Checked:= HorizontalScroll;
      edtMouseHorzPart.Text:= IntToStr(HorizontalPart);
      edtMouseHorzPart.Enabled:= HorizontalScroll;
      cbMouseCursors.Checked:= CustomCursors;
    end;
    with HighlightMode do begin
      edtHighlightBlendCl.Text:= Cl32ToHex(BlendColor);
      edtHighlightGlowCl.Text:= Cl32ToHex(DarkHlC);
      edtHighlightPlayerPriCl.Text:= Cl32ToHex(PlayerPriHlC);
      edtHighlightPlayerSecCl.Text:= Cl32ToHex(PlayerSecHlC);
      edtHighlightPicWeight.Text:= IntToStr(Weight);
    end;
    with DarkMode do begin
      edtNightBlendingCl.Text:= Cl32ToHex(BlendColor);
      edtNightPicWeight.Text:= IntToStr(Weight);
    end;
    with UndoOptions do begin
      cbRestrictUndo.Checked:= Restrict;
      edtUndoRestrict.Text:= IntToStr(MaxLevel);
      cbRestrictUndoClick(Self);
    end;
    with InterfaceOptions do begin
      cbCloseBtn.Checked:= ShowCloseBtn;
      if ToolBarAlign = alTop then rbtnTBAlignTop.Checked:= True
        else rbtnTBAlignBottom.Checked:= True;
      cbSounds.Checked:= Sounds;
      cbDecimalIndicator.Checked:= DecimalIndicator;
      btnRefreshTransList.Click; // refresh list
      with lbTransFiles do ItemIndex:= Items.IndexOf(LangFile);
    end;
    with Tools do begin
      cbCustomRecolor.Checked:= CustomRecolorer;
    end;
    cbxZoomLevel.ItemIndex:= Round(Log2(DefZoomLevel));
    cbxFilesPngCompLevel.ItemIndex:= PNGCompression;
    cbAddToRecent.Checked:= AddToRecent;
    cbTimeStamp.Checked:= TimeStamp;
  end;
end;

//------------------------------------------------------------------------------

procedure TOptionFrm.btnOKClick(Sender: TObject);
var O: TSdiEdOptions;
    Continue: Boolean;
    ErrorStr: String;
    ErrorComp: TComponent;
  //....................
  procedure SetError(const Reason: String; Location: TComponent);
  begin
    ErrorStr:= Reason;
    ErrorComp:= Location;
  end;
  //....................
begin
  Continue:= False;
  ErrorComp:= Self;
  ErrorStr:= 'Unknown error.'; //t+
  with O do try try
    with HighlightMode do begin
      SetError(sscErrHiBlend, edtHighlightBlendCl);
      BlendColor:= HexToCl32(edtHighlightBlendCl.Text);
      SetError(sscErrHiSpec, edtHighlightGlowCl);
      DarkHlC:= HexToCl32(edtHighlightGlowCl.Text);
      SetError(sscErrHiPlayerPri, edtHighlightPlayerPriCl);
      PlayerPriHlC:= HexToCl32(edtHighlightPlayerPriCl.Text);
      SetError(sscErrHiPlayerSec, edtHighlightPlayerSecCl);
      PlayerSecHlC:= HexToCl32(edtHighlightPlayerSecCl.Text);
      SetError(sscErrHiWeight, edtHighlightPicWeight);
      Weight:= EnsureRange(StrToInt(edtHighlightPicWeight.Text), 0, 255);
    end;
    with DarkMode do begin
      SetError(sscErrNightBlend, edtNightBlendingCl);
      BlendColor:= HexToCl32(edtNightBlendingCl.Text);
      SetError(sscErrNightWeight, edtNightPicWeight);
      Weight:= EnsureRange(StrToInt(edtNightPicWeight.Text), 0, 255);
     end;
    SetError(sscErrVCLError, cbxZoomLevel);
    with cbxZoomLevel do DefZoomLevel:= StrToInt(Items[ItemIndex]);
    SetError(sscErrVCLError, cbxFilesPngCompLevel);
    PNGCompression:= cbxFilesPngCompLevel.ItemIndex;
    with MouseOpt do begin
      SetError(sscErrMouseScrollX, edtMouseScrollX);
      ScrollFactorX:= StrToInt(edtMouseScrollX.Text);
      SetError(sscErrMouseScrollY, edtMouseScrollY);
      ScrollFactorY:= StrToInt(edtMouseScrollY.Text);
      SetError(sscErrVCLError, cbMouseHorzScroll);
      HorizontalScroll:= cbMouseHorzScroll.Checked;
      SetError(sscErrMouseThreshold, edtMouseHorzPart);
      HorizontalPart:= Abs(StrToInt(edtMouseHorzPart.Text)); // no negatives!
      SetError(sscErrVCLError, cbMouseCursors);
      CustomCursors:= cbMouseCursors.Checked;
    end;
    with UndoOptions do begin
      SetError(sscErrVCLError, cbRestrictUndo);
      Restrict:= cbRestrictUndo.Checked;
      SetError(sscErrMaxUndoNotNumber, edtUndoRestrict);
      MaxLevel:= Abs(StrToInt(edtUndoRestrict.Text));
    end;
    with InterfaceOptions do begin
      SetError(sscErrVCLError, cbCloseBtn);
      ShowCloseBtn:= cbCloseBtn.Checked;
      SetError(sscErrVCLError, rbtnTBAlignTop);
      if rbtnTBAlignTop.Checked then ToolBarAlign:= alTop
        else ToolBarAlign:= alBottom;
      SetError(sscErrVCLError, cbSounds);
      Sounds:= cbSounds.Checked;
      SetError(sscErrVCLError, cbDecimalIndicator);
      DecimalIndicator:= cbDecimalIndicator.Checked;
      SetError(sscErrVCLError, lbTransFiles);
      with lbTransFiles do if ItemIndex > -1 then begin
        LangFile:= Items[ItemIndex];
        // reverse-translate all "static" labels, dynamic will change after
        // relevant changes
        InvertTranslation;
        TranslateComponents([MainFrm, AboutFrm, BackPicFrm, ClChgFrm, NightOptFrm, OptionFrm]);
        ChangeTranslation(GoodSlashes(AppPath + 'translations/' + LangFile));
        TranslateComponents([MainFrm, AboutFrm, BackPicFrm, ClChgFrm, NightOptFrm, OptionFrm]);
      end;
    end;
    with Tools do begin
      SetError(sscErrVCLError, cbCustomRecolor);
      CustomRecolorer:= cbCustomRecolor.Checked;
    end;
    SetError(sscErrVCLError, cbAddToRecent);
    AddToRecent:= cbAddToRecent.Checked;
    SetError(sscErrVCLError, cbTimeStamp);
    TimeStamp:= cbTimeStamp.Checked;
    IniFileKind:= FOptions.IniFileKind;
    Continue:= True; // everyhing set without exceptions, it can go on
  except on E:Exception do begin
    {$IFDEF DEBUG}
    // !!! Debug mode may fail here if the ErrorComp is not assigned...
    ErrorStr:= _('Problem: ') + Translate(ErrorStr) + #10 //t+
      + _('Location: ') + ErrorComp.Name + ':' + ErrorComp.ClassName //t+-
      + #10 + _('Exception Class: ') + E.ClassName + #10 //t+
      + _('Exception message: ') + E.Message; //t+
    {$ELSE}
    ErrorStr:= _('Problem: ') + Translate(ErrorStr); //t+
    {$ENDIF}
    Application.MessageBox(PChar(ErrorStr), PChar(Translate(sscMsgCapError)),
      MB_OK + MB_ICONERROR);
  end; end; finally
    if Continue then begin
      FOptions:= O;
      ModalResult:= mrOk;
    end;
  end;
end;

//------------------------------------------------------------------------------

procedure TOptionFrm.FormCreate(Sender: TObject);
var i: Integer;
    CompFont: TFont;
    CompParentFont: Integer;
  //...............
  procedure SetImage(const AImage: TImage; PicIndex: Integer);
  begin
    with AImage, Picture, Bitmap do begin
      // For description of image loading code look into NightOptU. Here is
      // handled tranparency, too.
      AImage.Transparent:= True;
      Bitmap.TransparentColor:= clFuchsia; // ImageList.BkColor
      MainFrm.ImageList.GetBitmap(PicIndex, Bitmap); // areas
      FreeImage;
    end;
  end;
  //...............
begin
  PageControl.ActivePageIndex:= 0;
  SetImage(imgHighlight, 3);
  Setimage(imgNight, 2);
  SetImage(imgFiles, 16);
  SetImage(imgMouse, 9);
  SetImage(imgZoom, 10);
  SetImage(imgUndo, 21);
  SetImage(imgInterface, 20);
  SetImage(imgTools, 8);
  TranslateComponent(Self);
  Font.Name:= Translate(sscFontName);
  for i:= 0 to ComponentCount - 1 do if IsPublishedProp(Components[i], 'Font') then begin
    CompFont:= TFont(GetObjectProp(Components[i], 'Font'));
    CompParentFont:= GetOrdProp(Components[i], 'ParentFont');
    if (CompFont.Name = sscFixedWidthFontName) and (CompParentFont = 0) then
      CompFont.Name:= Translate(sscFixedWidthFontName);
      // ^ is a reference - no need to assign back 
  end;
end;

//------------------------------------------------------------------------------

procedure TOptionFrm.cbMouseHorzScrollClick(Sender: TObject);
begin
  edtMouseHorzPart.Enabled:= cbMouseHorzScroll.Checked;
end;

//------------------------------------------------------------------------------

procedure TOptionFrm.ColorEditChange(Sender: TObject);
var Shape: TShape;
    Edit: TEdit;
    TargetName: String;
    NewCl: TColor32;
begin
  try
    try
      Edit:= Sender as TEdit;
      TargetName:= Edit.Name;
      //Move('shp', TargetName, 3);
      TargetName[1]:= 's';
      TargetName[2]:= 'h';
      TargetName[3]:= 'p';
      Shape:= FindComponent(TargetName) as TShape;
      NewCl:= HexToCl32Def(Edit.Text, clBlack32);
      with Shape.Pen do begin
        Color:= clBlack;
        Width:= 1;
      end;
    except
      on E: EColorConvertException do begin
        NewCl:= clBlack32;
        with Shape.Pen do begin
          Color:= clRed;
          Width:= 2;
        end;
      end;
    end;
  finally
    Shape.Brush.Color:= WinColor(NewCl);
  end;
end;

//------------------------------------------------------------------------------

procedure TOptionFrm.cbRestrictUndoClick(Sender: TObject);
begin
  edtUndoRestrict.Enabled:= cbRestrictUndo.Checked;
end;

//------------------------------------------------------------------------------

procedure TOptionFrm.btnShowDataFolderClick(Sender: TObject);
begin
  WinOpen(Handle, MainU.DataPath);
end;

//------------------------------------------------------------------------------

procedure TOptionFrm.FormShow(Sender: TObject);
begin
  btnShowDataFolder.Enabled:= MainFrm.Options.IniFileKind = iftFile;
end;

//------------------------------------------------------------------------------

procedure TOptionFrm.btnRefreshTransListClick(Sender: TObject);
var Files: TStrings;
    i: Integer;
begin
  Files:= TStringList.Create;
  FindFilesByMask(GoodSlashes(AppPath + 'translations/*.po'), Files);
  with Files do if Count > 0 then for i:= 0 to Count - 1 do
    Strings[i]:= ExtractFileName(Strings[i]);
  lbTransFiles.Items.Assign(Files);
  Files.Free;
end;

//------------------------------------------------------------------------------

procedure TOptionFrm.btnAutoChooseTransClick(Sender: TObject);
var Old, New: Integer;
begin
  with lbTransFiles do begin
    Old:= ItemIndex;
    New:= Items.IndexOf(ChooseTranslationFile(
      GetSystemLanguageName, Items, GetSystemLanguageName + '.po'));
    if New = -1 then New:= Items.IndexOf('en.po');
    if New = -1 then New:= Old;
    ItemIndex:= New;
  end;
end;

//------------------------------------------------------------------------------

end.
