unit DynIntU;

interface             // TAK TADY PROBIHA TEN UPLNY ZAKLAD - PRACE S PAMETI

uses SysUtils, Windows;

type TDynInt = record
       Length: Cardinal;
       Mem: Pointer;
     end;

procedure DICreate(var DI: TDynInt; const Length: Cardinal = 0); // vytvori novy DynInt
procedure DIFree(var DI: TDynInt);   // zrusi DynInt
procedure DICopy(var Dest: TDynInt; const Source: TDynInt); // zkopiruje DynInt
procedure DISetLength(var DI: TDynInt; const Length: Cardinal); // nastavi delku
function DIGet(const DI: TDynInt; const Index: Cardinal): Byte; // vytahne hodnotu
procedure DISet(const DI: TDynInt; const Index: Cardinal; const Value: Byte);

implementation

procedure DICreate(var DI: TDynInt; const Length: Cardinal = 0);
begin
  DI.Length := Length;
  if Length <> 0 then begin                   
    GetMem(DI.Mem, DI.Length);
    ZeroMemory(DI.Mem, DI.Length);
  end;
end;

//------------------------------------------------------------------------------

procedure DIFree(var DI: TDynInt);
begin
  if (DI.Length <> 0) then begin
    FreeMem(DI.Mem, DI.Length);     // zrusi se pamet
    DI.Length := 0;                 // a delka nastavi na nulu
  end;
end;

//------------------------------------------------------------------------------

procedure DICopy(var Dest: TDynInt; const Source: TDynInt);
begin
  if Source.Length <> Dest.Length then begin
    if Dest.Length <> 0 then FreeMem(Dest.Mem, Dest.Length);
    GetMem(Dest.Mem, Source.Length);
    Dest.Length := Source.Length;
  end;
  CopyMemory(Dest.Mem, Source.Mem, Source.Length);
end;

//------------------------------------------------------------------------------

procedure DISetLength(var DI: TDynInt; const Length: Cardinal);
var Tmp: TDynInt;
begin
  if Length <> DI.Length then begin  // provede se jen kdyz opravdu menime
    if Length = 0 then DIFree(DI) else if DI.Length = 0 then begin // nastaveni na 0 = smazani
      DI.Length := Length;      // kdyz je DI.Length 0 tak jen alokujeme
      GetMem(DI.Mem, DI.Length);
      ZeroMemory(DI.Mem, DI.Length);
    end else begin
      DICreate(Tmp, DI.Length);      // vytvorime docasne
      DICopy(Tmp, DI);               // zkopirujeme puvodni data 
      FreeMem(DI.Mem, DI.Length);    // smazeme puvodni
      DI.Length := Length;           // a naalokujeme pamet o nove delce
      GetMem(DI.Mem, DI.Length);
      if DI.Length > Tmp.Length then begin  // jestlize je vetsi
        ZeroMemory(DI.Mem, DI.Length);      // tak kopirujeme cele puvodni
        CopyMemory(DI.Mem, Tmp.Mem, Tmp.Length);
      end else CopyMemory(DI.Mem, Tmp.Mem, DI.Length); // jinak jen cast o nove delce
    end;
  end;  
end;

//------------------------------------------------------------------------------

function DIGet(const DI: TDynInt; const Index: Cardinal): Byte;
begin
  if Index < DI.Length then Result := PByte(Cardinal(DI.Mem) + Index)^ else
    raise Exception.Create(
    'DIGet Index invalid: '+IntToStr(Index)+' Length: '+IntToStr(DI.Length));
end;

//------------------------------------------------------------------------------

procedure DISet(const DI: TDynInt; const Index: Cardinal; const Value: Byte);
begin
  if Index < DI.Length then PByte(Cardinal(DI.Mem) + Index)^ := Value else
    raise Exception.Create(
    'DISet Index invalid: '+IntToStr(Index)+' Length: '+IntToStr(DI.Length)); 
end;

//------------------------------------------------------------------------------

end.
